cd""
use "数据.dta",clear
global z age size tl roa cash  growth gdp_dis  road_dis  pop_dis
global z1  age size tl roa cash  growth 

pwcorr  IRI   GF $z 
sum  IRI   GF $z
logout, save(table) word replace:  ///
tabstat   IRI GF $z , s(N mean p50 sd min max) format(%9.3f) c(s)
asdoc sum IRI GF $z , dec(3), save(表1描述性统计.doc) title("描述性统计")

****基准回归********************************************************************
reghdfe IRI GF  ,  a(year aa1 s_city  )   keepsing 
 est store m1
reghdfe IRI GF   $z1   , a(year aa1  s_city ) keepsing 
 est store m2
reghdfe IRI GF  $z, a(year aa1  s_city ) keepsing 
 est store m3
esttab m1 m2 m3     /*using  "表2基准回归.rtf"  */ ,nogap replace  ///
  r2 scalar ("年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
 b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) 
 
****内生性处理******************************************************************
ivreghdfe  IRI $z (GF =IV) , a(year aa1 s_city) keepsing  first
est store m1
esttab m1   /*using  "表3内生性处理.rtf"  */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"  `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z)

****机制检验********************************************************************
/*市场效应*/
reghdfe   IRI  c.GF##c.VCC  $z     , a(year aa1 s_city )   keepsing
est store m1
reghdfe   IRI  c.GF##c.VCN  $z    , a(year aa1 s_city )   keepsing
est store m2
reghdfe   IRI  c.GF##c.RAE  $z   , a(year aa1 s_city )   keepsing
est store m3
reghdfe   IRI  c.GF##c.MP  $z   , a(year aa1 s_city )   keepsing
est store m4
esttab m1 m2  m3 m4  /*   using  "表4资金杠杆与市场化效应.rtf"  */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z )

/*金融赋能效应*/
reghdfe   IRI  c.GF##c.FPS  $z , a(year aa1 s_city )   keepsing
est store m1
reghdfe   IRI  c.GF##c.FDS  $z , a(year aa1 s_city )   keepsing
est store m2
reghdfe   IRI  c.GF##c.FCS  $z , a(year aa1 s_city )   keepsing
est store m3
reghdfe   IRI  c.GF##c.FT  $z , a(year aa1 s_city )   keepsing
est store m4
reghdfe   IRI  c.GF##c.DIF  $z , a(year aa1 s_city )   keepsing
est store m5
esttab m1 m2  m3 m4 m5   /* using  "表5金融集聚与科技赋能效应.rtf" */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z )
 
/*产业协同效应*/  
reghdfe   IRI  c.GF##c.SIA   $z   , a(year aa1 s_city )   keepsing
est store m1
reghdfe   IRI  c.GF##c.DIA   $z     , a(year aa1 s_city )   keepsing
est store m2
reghdfe   IRI  c.GF##c.IU   $z , a(year aa1 s_city)   keepsing
est store m3
esttab m1 m2 m3  /* using  "表6产业集聚与创新升级效应.rtf"    */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z )
  
****异质性分析****************************************************************** 
**1.城市异质性
/*经济发展水平:将每年城市人均GDP中位数作为城市经济发展（developed）的分组标准，低于中位数的样本定义为欠发达城市（developed=0）；反之则为发达城市（developed=1）。
财政自给率:使用地方财政一般公共预算收入除以一般公共预算支出得到财政水平（fiscal），然后根据每年城市财政自给率的中位数将样本划分为财政宽松城市（fiscal=1）和财政紧缩城市（fiscal=0）*/

reghdfe   IRI   GF  $z  if developed==1 , a(year aa1 s_city )   keepsing
est store m1
reghdfe   IRI   GF  $z  if developed==0, a(year aa1 s_city )   keepsing
est store m2
reghdfe   IRI   GF  $z  if fiscal==1 , a(year aa1 s_city )   keepsing
est store m3
reghdfe   IRI   GF  $z  if fiscal==0 , a(year aa1 s_city )   keepsing
est store m4
esttab m1 m2  m3 m4 /* using  "表7城市异质性.rtf"   */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z )
 
**2.投资异质性
/*高技术产业：根据《高技术产业（服务业）分类（2018）》和《高技术产业（制造业）分类（2017）》判定，高技术产业（ind_tech=1）、非高技术行业（ind_tech=0）
高技术企业：高技术企业（ent_tech=1）、非高技术企业（ent_tech=0）*/
 
reghdfe   IRI  GF   $z  if ind_tech==1    , a(year   s_city )   keepsing
est store m1
reghdfe   IRI  GF   $z    if ind_tech==0 , a(year   s_city)   keepsing
est store m2
reghdfe   IRI  GF  $z  if ent_tech==1    , a(year aa1 s_city )   keepsing
est store m3
reghdfe   IRI  GF    $z if ent_tech==0 , a(year aa1 s_city)   keepsing
est store m4
esttab m1 m2  m3 m4  /*  using  "表8投资异质性.rtf" */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z )

**3.企业性质异质性
/*国有企业（soe=1）、非国有企业（soe=0）*/
/*大规模企业（size1=1）、中小规模企业（size1=0）*/
 
reghdfe   IRI  GF  $z  if soe==1    , a(year aa1 s_city )   keepsing
est store m1
reghdfe   IRI  GF    $z if soe==0 , a(year aa1 s_city)   keepsing
est store m2
reghdfe   IRI  GF  $z  if  size1==1    , a(year aa1 s_city )   keepsing
est store m3
reghdfe   IRI  GF    $z if  size1==0 , a(year aa1 s_city)   keepsing
est store m4
esttab m1 m2  m3 m4 /*  using  "表9企业性质异质性.rtf"  */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z )
 

****附录************************************************************************
****附录************************************************************************ 
**稳健性检验
/*替换变量：y、x*/
reghdfe IRN GF  $z,  a(year aa1 s_city  )   keepsing 
est store m1 
reghdfe C_IRI GF   $z  , a(year aa1  s_city ) keepsing 
est store m2
reghdfe C_IRN GF   $z  , a(year aa1  s_city ) keepsing 
est store m3
reghdfe IRI GFP $z ,  a(year aa1 s_city  )   keepsing 
est store m4
reghdfe  IRI GFC  $z    , a( year aa1 s_city) keepsing  
est store m5
reghdfe IRI  GS  $z  , a(year aa1  s_city ) keepsing 
est store m6 
esttab m1 m2 m3 m4 m5 m6  /*using  "附表1替代变量.rtf"  */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
 b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z)
 
/*排除其他干扰*/ 
reghdfe   IRI  GF  $z   if  year<2020 , a(year aa1 s_city)   keepsing
est store m1
reghdfe   IRI GF  FR   $z    , a(year aa1 s_city)    keepsing
est store m2
reghdfe   IRI GF  IC  $z    , a(year aa1 s_city)    keepsing
est store m3
reghdfe   IRI GF  GD   $z    , a(year aa1 s_city)    keepsing
est store m4
esttab m1 m2 m3  m4 /*  using  "附表2排除干扰.rtf"    */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z)
 
/*混淆因素：时间趋势*/
reghdfe   IRI  GF  $z   y1 y2 y3  , a(year aa1 s_city )   keepsing
est store m1
reghdfe   IRI  GF    $z  cy1 cy2 cy3  , a(year aa1 s_city)   keepsing
est store m2
reghdfe   IRI  GF    $z   hy1 hy2 hy3  , a(year aa1 s_city)   keepsing
est store m3
reghdfe   IRI   GF  $z  per_gdp pop gov fin internet road ind2 ind3 e_tax  s_tax, a(year aa1 s_city)   keepsing  
est store m4
/*drop tau mills
probit n2  $z1    c.year  c.aa1 
est store m_s
 predict tau, xb
gen IMR=normalden(tau)/normal(tau)*/
reghdfe IRI GF IMR $z, a(year aa1  s_city ) keepsing 
est store m5	
esttab m1 m2  m3 m4 m5 /*  using  "附表3混淆因素和自选择.rtf"    */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定"  "企业城市固定" "城市固定"   `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 ) drop($z y* cy* hy*)

**企业的经济后果
reghdfe  TFP c.IRI##c.GF  $z  , a(year aa1 s_city )   keepsing
est store m1 
reghdfe  DFC  c.IRI##c.GF  $z  , a(year aa1 s_city )   keepsing 
est store m2
reghdfe  TI  c.IRI##c.GF  $z  , a(year aa1 s_city )   keepsing
est store m3
esttab m1 m2 m3  /*using  "附表4企业的经济后果.rtf"  */ ,nogap replace  ///
r2 scalar ("控制变量" "年份固定效应" "企业城市固定效应" "城市固定效应" `ss'   N)  ///
b(%6.3f) se(%6.3f) star(* 0.1  ** 0.05  *** 0.01 )  drop ($z) 
